<?php
include("include/conn.php"); // your DB connection

$amount   = isset($_GET['amount']) ? filter_var($_GET['amount'], FILTER_VALIDATE_FLOAT) : '';
$order_id = isset($_GET['order_id']) ? filter_var($_GET['order_id'], FILTER_SANITIZE_STRING) : '';
$user_id  = isset($_GET['user_id']) ? filter_var($_GET['user_id'], FILTER_VALIDATE_INT) : '';

// Validate inputs
if (empty($order_id) || empty($user_id) || $amount === false) {
    echo "<script>
            document.querySelector('.loader').style.display='none';
            document.querySelector('.msg').innerHTML = '<span class=\"failed\">Invalid input parameters. Please try again.</span>';
          </script>";
    exit;
}

// Check for duplicate order_id
$checkStmt = $conn->prepare("SELECT id FROM transaction_details WHERE order_id = ?");
$checkStmt->bind_param("s", $order_id);
$checkStmt->execute();
$checkResult = $checkStmt->get_result();
if ($checkResult->num_rows > 0) {
    echo "<script>
            document.querySelector('.loader').style.display='none';
            document.querySelector('.msg').innerHTML = '<span class=\"failed\">Transaction already processed for Order ID: {$order_id}</span>';
          </script>";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Payment Status</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            background: #f7f7f7;
            padding-top: 100px;
        }
        .loader {
            border: 8px solid #f3f3f3;
            border-radius: 50%;
            border-top: 8px solid #3498db;
            width: 60px;
            height: 60px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0%   { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .msg {
            font-size: 18px;
            margin-top: 20px;
        }
        .success { color: green; font-weight: bold; }
        .failed { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <h2 class="loader-msg">Please wait...</h2>
    <div class="loader"></div>
    <p class="msg">We are checking your payment status.<br>Do not close this window.</p>

<?php
flush(); // send above HTML immediately to browser

// ====== API CALL ======
$apiUrl = "https://tss.ngdinesh.com/api/check-order-status";
$user_token = "305fb2bb54e6b5122aeb31b18c6ca871";

$postData = http_build_query([
    'user_token' => $user_token,
    'order_id'   => $order_id
]);

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/x-www-form-urlencoded'
]);

$response = curl_exec($ch);
if ($response === false) {
    $curl_error = curl_error($ch);
    file_put_contents('curl_error.log', "cURL Error: $curl_error\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);
    echo "<script>
            document.querySelector('.loader').style.display='none';
            document.querySelector('.msg').innerHTML = '<span class=\"failed\">API request failed. Please try again.</span>';
          </script>";
    curl_close($ch);
    exit;
}
curl_close($ch);

// Log raw response for debugging
file_put_contents('api_response.log', "Response: $response\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);

// Decode JSON
$result = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    file_put_contents('json_error.log', "JSON Error: " . json_last_error_msg() . "\nRaw Response: $response\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);
    echo "<script>
            document.querySelector('.loader').style.display='none';
            document.querySelector('.msg').innerHTML = '<span class=\"failed\">Invalid API response. Please try again.</span>';
          </script>";
    exit;
}

// Log status for debugging
file_put_contents('status.log', print_r($result, true) . "\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);

// ====== PROCESS ======
if (isset($result['message']) && $result['message'] === 'Transaction Successfully') {
    // Log success condition details
    file_put_contents('success_details.log', "Success condition met: status=" . ($result['status'] ?? 'N/A') . ", result.status=" . ($result['result']['status'] ?? 'N/A') . "\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);

    $txnAmount = $result['result']['amount'] ?? $amount; // Fallback to GET amount
    $utr       = $result['result']['utr'] ?? 'N/A'; // Fallback if utr is missing

    // ✅ Store raw Unix timestamp (not formatted date)
    $txnDate = $result['result']['date'] ?? time();
    if (!is_numeric($txnDate)) {
        $txnDate = time();
    }

    // Insert transaction
    $insert = $conn->prepare("INSERT INTO transaction_details 
        (user_id, order_id, payment_id, request_name, req_from, req_amount, coins_used, getway_name, remark, type, status, date)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $req_from   = "APP";
    $gateway    = "NGDinesh";
    $remark     = "Added Via NG Dinesh";
    $type       = 1;
    $status     = 1;
    $coins_used = $txnAmount;

    // ✅ Note: last param type changed to "i" for integer timestamp
    $insert->bind_param("issssissssii", $user_id, $order_id, $utr, $user_id, $req_from, $txnAmount, $coins_used, $gateway, $remark, $type, $status, $txnDate);
    if (!$insert->execute()) {
        file_put_contents('db_error.log', "Insert Error: " . $insert->error . "\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);
        echo "<script>
                document.querySelector('.loader').style.display='none';
                document.querySelector('.loader-msg').style.display='none';
                document.querySelector('.msg').innerHTML = '<span class=\"failed\">Failed to save transaction. Please contact support.</span>';
              </script>";
        exit;
    }

    // Update user balance
    $update = $conn->prepare("UPDATE user_details SET cur_balance = cur_balance + ? WHERE id = ?");
    $update->bind_param("di", $txnAmount, $user_id);
    if (!$update->execute()) {
        file_put_contents('db_error.log', "Update Error: " . $update->error . "\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);
    }

    // Fetch updated balance
    $balanceStmt = $conn->prepare("SELECT cur_balance FROM user_details WHERE id = ?");
    $balanceStmt->bind_param("i", $user_id);
    $balanceStmt->execute();
    $balanceRes = $balanceStmt->get_result();
    if ($balanceRow = $balanceRes->fetch_assoc()) {
        $newBalance = $balanceRow['cur_balance'];
    } else {
        $newBalance = 'N/A';
        file_put_contents('db_error.log', "User not found for ID: $user_id\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);
    }

    echo "<script>
            document.querySelector('.loader').style.display='none';
            document.querySelector('.msg').innerHTML = '<span class=\"success\">Payment Successful! ✅<br>Amount ₹{$txnAmount} added.<br>Your new balance: ₹{$newBalance}</span>';
          closeAfterDelay();
          </script>";
} else {
    $errorMsg = isset($result['message']) ? $result['message'] : 'Unknown error';
    file_put_contents('error_details.log', "Failed condition: status=" . ($result['status'] ?? 'N/A') . ", result.status=" . ($result['result']['status'] ?? 'N/A') . "\n" . print_r($result, true) . "\nInput: order_id=$order_id, user_id=$user_id, amount=$amount\n", FILE_APPEND);
    echo "<script>
            document.querySelector('.loader').style.display='none';
            document.querySelector('.msg').innerHTML = '<span class=\"failed\">Payment Failed ❌<br>Error: {$errorMsg}</span>';
            closeAfterDelay();
          </script>";
}
?>

<script>
    function closeAfterDelay() {
        setTimeout(function() {
            // This will work inside WebView (Android)
            if (typeof Android !== "undefined" && Android.closeScreen) {
                Android.closeScreen(); // Calls WebView interface method
            } else {
                // Fallback: close browser tab (if opened in normal browser)
                window.close();
            }
        }, 5000); // 5 seconds
    }
</script>

</body>
</html>
