<?php
include './include/conn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'], $_POST['status'])) {
    $id = intval($_POST['id']);
    $new_status = in_array($_POST['status'], ['0', '1', '2']) ? $_POST['status'] : '0';

    // Fetch payment details
    $getPayment = $conn->query("SELECT * FROM tbl_offline_plyments WHERE id = $id");
    if ($getPayment && $getPayment->num_rows > 0) {
        $payment = $getPayment->fetch_assoc();

        $user_id = intval($payment['user_id']);
        $coins = intval($payment['coins']);
        $amount = $payment['amount'];
        $wallet = $payment['wallet'];
        $transaction_id = $payment['transaction_id'];
        $old_status = $payment['status'];

        // ✅ Store current time instead of created_at
        $date = time();

        // Update user balance if status is Approved
        if ($old_status === '0' && $new_status === '1') {
            $conn->query("UPDATE user_details SET cur_balance = cur_balance + $coins WHERE id = $user_id");
        }

        // Revert balance if going back to Pending from Approved
        if ($old_status === '1' && $new_status === '0') {
            $conn->query("UPDATE user_details SET cur_balance = cur_balance - $coins WHERE id = $user_id");
        }

        // Prepare data for transaction table
        $request_name = 'Wallet Deposit';
        $req_from = 'Offline Payment';
        $gateway_name = 'Manual';
        $type = '1'; // credit
        $remark = ($new_status === '2') ? 'Rejected offline payment' : (($new_status === '1') ? 'Approved offline payment' : 'Pending offline payment');

        $status_val = intval($new_status);

        // Check if transaction already exists
        $check = $conn->query("SELECT id FROM transaction_details WHERE payment_id = '$transaction_id' LIMIT 1");

        if ($check && $check->num_rows > 0) {
            // Update existing transaction
            $stmt = $conn->prepare("UPDATE transaction_details SET 
                status = ?, remark = ? WHERE payment_id = ?");
            $stmt->bind_param("iss", $status_val, $remark, $transaction_id);
            $stmt->execute();
        } else {
            // Insert new transaction
            $stmt = $conn->prepare("INSERT INTO transaction_details 
                (user_id, order_id, payment_id, request_name, req_from, req_amount, coins_used, getway_name, remark, type, status, date)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssssisssis",
                $user_id,
                $transaction_id,
                $transaction_id,
                $request_name,
                $req_from,
                $amount,
                $coins,
                $gateway_name,
                $remark,
                $type,
                $status_val,
                $date // ← using UNIX timestamp
            );
            $stmt->execute();
        }

        // Update offline payment status
        $stmt = $conn->prepare("UPDATE tbl_offline_plyments SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $new_status, $id);
        $stmt->execute();
    }
}

header("Location: offline-payments.php");
exit;
?>
