<?php 
include("include/security.php");
include("include/conn.php");

// Handle AJAX request for fetching users
if (isset($_GET['action']) && $_GET['action'] === 'get_users') {
    header('Content-Type: application/json');
    
    $users_query = "SELECT id, CONCAT(fname, ' ', lname) as full_name, username, email FROM user_details ORDER BY fname ASC";
    $users_result = mysqli_query($conn, $users_query);
    $users = [];
    
    while($row = mysqli_fetch_assoc($users_result)) {
        $users[] = [
            'id' => $row['id'],
            'text' => $row['full_name'] . ' (' . $row['username'] . ' - ' . $row['email'] . ')',
            'full_name' => $row['full_name'],
            'username' => $row['username'],
            'email' => $row['email']
        ];
    }
    
    echo json_encode(['status' => 'success', 'users' => $users]);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Send Notification</title>
    
    <?php include_once("include/head-section.php"); ?>
    
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    
    <style type="text/css">
        .validation {
            font-size: 12px;
            color: #f6504d;
        }
        .validation-box {
            border-color: #f6504d;
        }
        .select2-container {
            width: 100% !important;
        }
        .notification-response {
            margin-top: 15px;
            padding: 10px;
            border-radius: 4px;
            display: none;
        }
        .success {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        .error {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }
        .loading {
            background-color: #d1ecf1;
            border: 1px solid #bee5eb;
            color: #0c5460;
        }
        .loading-users {
            text-align: center;
            padding: 10px;
            color: #666;
        }
    </style>
</head>

<body class="fixed-left">
    <div id="wrapper">
        <?php include_once("include/navbar.php"); ?>
        
        <div class="content-page">
            <div class="content">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="card-box">
                                <h4 class="m-t-0 header-title"><b>Send Notification</b></h4>
                                <p class="text-muted font-13 m-b-30">Send notifications to users.</p>
                                
                                <div id="notification-response" class="notification-response"></div>
                                
                                <form id="notification-form" enctype="multipart/form-data">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="notification_title">Title *</label>
                                                        <input type="text" name="notification_title" id="notification_title" class="form-control" placeholder="Enter notification title" required>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="notification_msg">Message *</label>
                                                        <textarea name="notification_msg" id="notification_msg" class="form-control" rows="4" placeholder="Enter notification message" required></textarea>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="image_url">Image URL</label>
                                                        <input type="url" name="image_url" id="image_url" class="form-control" placeholder="https://example.com/image.jpg">
                                                        <small class="text-muted">Enter a URL for the notification image (e.g., https://example.com/image.jpg). Recommended resolution: 600x293 or 650x317 or 700x342 or 750x366</small>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="send_type">Send To *</label>
                                                        <select name="send_type" id="send_type" class="form-control" required>
                                                            <option value="">Select Option</option>
                                                            <option value="all">All Users</option>
                                                            <option value="single">Single User</option>
                                                            <option value="multiple">Multiple Users</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-12" id="user-selection" style="display: none;">
                                                    <div class="form-group">
                                                        <label for="selected_users">Select Users</label>
                                                        <select name="selected_users[]" id="selected_users" class="form-control">
                                                            <option value="">Loading users...</option>
                                                        </select>
                                                        <div id="users-loading" class="loading-users" style="display: none;">
                                                            <i class="fa fa-spinner fa-spin"></i> Loading users...
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group text-right m-b-0">
                                                <button class="btn btn-primary waves-effect waves-light" type="submit" id="send-btn">
                                                    <span id="btn-text">Send Notification</span>
                                                    <span id="btn-loader" style="display: none;">
                                                        <i class="fa fa-spinner fa-spin"></i> Sending...
                                                    </span>
                                                </button>
                                                <button type="button" class="btn btn-default waves-effect waves-light m-l-5" onclick="resetForm()">Reset</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once("include/footer.php"); ?>
        </div>
    </div>

    <!-- jQuery and other scripts -->
    <?php include_once("include/common_js.php"); ?>
    
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            var usersData = [];
            var usersLoaded = false;

            // Function to load users via AJAX
            function loadUsers() {
                if (usersLoaded) return;
                
                $('#users-loading').show();
                
                $.ajax({
                    url: window.location.href,
                    type: 'GET',
                    data: { action: 'get_users' },
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            usersData = response.users;
                            usersLoaded = true;
                            populateUserDropdown();
                        } else {
                            showError('Failed to load users');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('Error loading users:', error);
                        showError('Error loading users: ' + error);
                    },
                    complete: function() {
                        $('#users-loading').hide();
                    }
                });
            }

            // Function to populate user dropdown
            function populateUserDropdown() {
                var selectedUsers = $('#selected_users');
                selectedUsers.empty();
                
                if (usersData.length === 0) {
                    selectedUsers.append('<option value="">No users found</option>');
                    return;
                }
                
                selectedUsers.append('<option value="">Select user(s)...</option>');
                
                $.each(usersData, function(index, user) {
                    selectedUsers.append('<option value="' + user.id + '">' + user.text + '</option>');
                });
                
                // Reinitialize Select2
                initializeSelect2();
            }

            // Function to initialize Select2
            function initializeSelect2() {
                var sendType = $('#send_type').val();
                var selectedUsers = $('#selected_users');
                
                // Destroy existing Select2
                if (selectedUsers.hasClass('select2-hidden-accessible')) {
                    selectedUsers.select2('destroy');
                }
                
                if (sendType === 'single') {
                    selectedUsers.prop('multiple', false);
                    selectedUsers.select2({
                        placeholder: "Select a user...",
                        allowClear: true
                    });
                } else if (sendType === 'multiple') {
                    selectedUsers.prop('multiple', true);
                    selectedUsers.select2({
                        placeholder: "Select users...",
                        allowClear: true
                    });
                }
            }

            // Handle send type change
            $('#send_type').on('change', function() {
                var sendType = $(this).val();
                var userSelection = $('#user-selection');
                var selectedUsers = $('#selected_users');
                
                if (sendType === 'single' || sendType === 'multiple') {
                    userSelection.show();
                    selectedUsers.prop('required', true);
                    
                    // Load users if not loaded
                    if (!usersLoaded) {
                        loadUsers();
                    } else {
                        initializeSelect2();
                    }
                } else {
                    userSelection.hide();
                    selectedUsers.prop('required', false);
                    if (selectedUsers.hasClass('select2-hidden-accessible')) {
                        selectedUsers.select2('destroy');
                    }
                }
            });

            // Handle form submission
            $('#notification-form').on('submit', function(e) {
                e.preventDefault();
                
                var formData = new FormData(this);
                var responseDiv = $('#notification-response');
                var sendBtn = $('#send-btn');
                var btnText = $('#btn-text');
                var btnLoader = $('#btn-loader');
                
                // Validate form
                if (!validateForm()) {
                    return;
                }
                
                // Show loading state
                sendBtn.prop('disabled', true);
                btnText.hide();
                btnLoader.show();
                responseDiv.removeClass('success error').addClass('loading').show().text('Sending notification...');
                
                $.ajax({
                    url: 'https://lic.cmhost.in/send_notification.php',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    timeout: 60000, // 60 seconds timeout
                    success: function(response) {
                        // Check only the status field
                        if (response.status === 'success') {
                            responseDiv.removeClass('loading error').addClass('success').text(response.message || 'Notification sent successfully!');
                            resetForm();
                        } else {
                            responseDiv.removeClass('loading success').addClass('error').text(response.message || 'Failed to send notification');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('Error Response:', xhr.responseText);
                        var errorMsg = 'Error: ' + error;
                        if (status === 'timeout') {
                            errorMsg = 'Request timeout. Please try again.';
                        }
                        responseDiv.removeClass('loading success').addClass('error').text(errorMsg);
                    },
                    complete: function() {
                        // Reset button state
                        sendBtn.prop('disabled', false);
                        btnText.show();
                        btnLoader.hide();
                    }
                });
            });

            // Form validation
            function validateForm() {
                var sendType = $('#send_type').val();
                var selectedUsers = $('#selected_users').val();
                
                if ((sendType === 'single' || sendType === 'multiple') && (!selectedUsers || selectedUsers.length === 0)) {
                    showError('Please select at least one user');
                    return false;
                }
                
                return true;
            }

            // Show error message
            function showError(message) {
                $('#notification-response').removeClass('success loading').addClass('error').show().text(message);
            }
        });

        // Reset form function
        function resetForm() {
            $('#notification-form')[0].reset();
            $('#selected_users').val(null);
            if ($('#selected_users').hasClass('select2-hidden-accessible')) {
                $('#selected_users').trigger('change');
            }
            $('#user-selection').hide();
            $('#notification-response').hide();
        }
    </script>
</body>
</html>