<?php
// get_match_participants.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST'); // Support both methods
header('Access-Control-Allow-Headers: Content-Type');

// Include your database connection
include("include/conn.php");

// Get match_id from either POST or GET data
$match_id = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $match_id = isset($_POST['match_id']) ? mysqli_real_escape_string($conn, $_POST['match_id']) : '';
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $match_id = isset($_GET['match_id']) ? mysqli_real_escape_string($conn, $_GET['match_id']) : '';
}

if (empty($match_id)) {
    echo json_encode(['error' => 'Match ID required']);
    exit;
}

// Fixed query with correct column name 'is_canceled'
$query = "SELECT 
            pd.id,
            pd.match_id,
            pd.user_id,
            pd.name as participant_name,
            ud.fcm_token,
            ud.username,
            CONCAT(ud.fname, ' ', ud.lname) as full_name
          FROM participant_details pd
          LEFT JOIN user_details ud ON pd.user_id = ud.id
          WHERE pd.match_id = '$match_id' 
          AND pd.is_canceled = '0'";

$result = mysqli_query($conn, $query);

if (!$result) {
    echo json_encode(['error' => 'Database query failed: ' . mysqli_error($conn)]);
    exit;
}

$participants = [];
while ($row = mysqli_fetch_assoc($result)) {
    $participants[] = [
        'id' => $row['id'],
        'match_id' => $row['match_id'],
        'user_id' => $row['user_id'],
        'participant_name' => $row['participant_name'],
        'fcm_token' => $row['fcm_token'],
        'username' => $row['username'],
        'full_name' => $row['full_name']
    ];
}

// Debug: Add total count
// $debug_info = [
//     'total_participants' => count($participants),
//     'match_id' => $match_id,
//     'query' => $query
// ];

// Return the participants data with debug info
echo json_encode([
    'participants' => $participants,
    // 'debug' => $debug_info
]);
?>
