<?php
// File: getData_offline.php

include_once 'include/conn.php';
include_once 'Pagination.class.php';

$limit = 10;
$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$offset = ($page - 1) * $limit;

$keywords = isset($_POST['keywords']) ? $conn->real_escape_string($_POST['keywords']) : '';
$sortBy = isset($_POST['sortBy']) ? $_POST['sortBy'] : '';

$whereSQL = "";
if (!empty($keywords)) {
    $whereSQL .= "WHERE u.fname LIKE '%$keywords%' OR u.lname LIKE '%$keywords%' OR p.transaction_id LIKE '%$keywords%'";
}

$orderSQL = "ORDER BY u.fname ASC";
if ($sortBy == "desc") {
    $orderSQL = "ORDER BY u.fname DESC";
}

$countQuery = $conn->query("SELECT COUNT(*) AS rowNum FROM tbl_offline_plyments AS p LEFT JOIN user_details AS u ON p.user_id = u.id $whereSQL");
$rowCount = $countQuery->fetch_assoc()['rowNum'];

$pagConfig = array(
    'baseURL' => 'getData_offline.php', 
    'totalRows' => $rowCount, 
    'perPage' => $limit, 
    'contentDiv' => 'postContent', 
    'link_func' => 'searchFilter'
);
$pagination = new Pagination($pagConfig);

$query = $conn->query("SELECT p.*, u.fname, u.lname, u.email FROM tbl_offline_plyments AS p LEFT JOIN user_details AS u ON p.user_id = u.id $whereSQL $orderSQL LIMIT $offset, $limit");

if ($query->num_rows > 0) {
    echo '<div class="table-responsive">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>User Name</th>
                <th>Email</th>
                <th>Transaction ID</th>
                <th>Amount</th>
                <th>Note</th>
                <th>Coins</th>
                <th>Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>';
    $i = $offset + 1;
    while ($row = $query->fetch_assoc()) {
        echo '<tr>
            <td>' . $i++ . '</td>
            <td>' . htmlspecialchars($row['fname'] . ' ' . $row['lname']) . '</td>
            <td>' . htmlspecialchars($row['email']) . '</td>
            <td>' . htmlspecialchars($row['transaction_id']) . '</td>
            <td>' . htmlspecialchars($row['amount']) . '</td>
            <td>' . htmlspecialchars($row['note']) . '</td>
            <td>' . htmlspecialchars($row['coins']) . '</td>
            <td>' . htmlspecialchars($row['created_at']) . '</td>
            <td>
                <form method="post" action="update-status.php">
                    <input type="hidden" name="id" value="' . $row['id'] . '">
                    <select name="status" onchange="this.form.submit()">
                        <option value="0" ' . ($row['status'] == '0' ? 'selected' : '') . '>Pending</option>
                        <option value="1" ' . ($row['status'] == '1' ? 'selected' : '') . '>Approved</option>
                        <option value="2" ' . ($row['status'] == '2' ? 'selected' : '') . '>Rejected</option>
                    </select>
                </form>
            </td>
        </tr>';
    }
    echo '</tbody></table></div>';
    echo $pagination->createLinks();
} else {
    echo '<p>No records found...</p>';
}
